// Aquastream.cpp : Rivatuner-Plugin fr Aquastream
//
// created by unwissender, basieren auf dem CPU-Beispiel-Plugin
//
/////////////////////////////////////////////////////////////////////////////
#define _CRT_SECURE_CPP_OVERLOAD_STANDARD_NAMES 1

#include <windows.h>
#include <float.h>
/////////////////////////////////////////////////////////////////////////////
#include "RivaTunerExports.h"
#include "MonitoringSourceDesc.h"
#include <string>
#include <sstream>
#include <memory>
#include <intrin.h>
#include "usbio.h"
using namespace std;

#define CPU_API extern "C" __declspec(dllexport)

/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////
// define and init global variables
/////////////////////////////////////////////////////////////////////////////
LOCALIZEWND_PROC			g_pLocalizeWnd					= NULL;
LOCALIZESTR_PROC			g_pLocalizeStr					= NULL;
HINSTANCE					    g_hModule  	  					= 0;
auto_ptr<Aquastream>  g_pAquastream;
int VERBOSE = 0;
/////////////////////////////////////////////////////////////////////////////
extern "C" int APIENTRY
DllMain(HINSTANCE hInstance, DWORD dwReason, LPVOID lpReserved)
{
  UNREFERENCED_PARAMETER(lpReserved);

  if (dwReason == DLL_PROCESS_ATTACH)
  {
    g_hModule	= hInstance;
  }
  else if (dwReason == DLL_PROCESS_DETACH)
  {
    g_pAquastream.reset();
  }
  return 1;
}
/////////////////////////////////////////////////////////////////////////////
// This helper funtrion is used to localize string if host application 
// supports localization
/////////////////////////////////////////////////////////////////////////////
LPCSTR LocalizeStr(LPCSTR lpStr)
{
  if (g_pLocalizeStr)
    return g_pLocalizeStr(lpStr);

  return lpStr;
}
/////////////////////////////////////////////////////////////////////////////
// This exported function is called by RivaTuner to get a number of
// data sources in this plugin
/////////////////////////////////////////////////////////////////////////////
CPU_API DWORD GetSourcesNum()
{
  return 7;
}
/////////////////////////////////////////////////////////////////////////////
// This exported function is called by RivaTuner to get descriptor
// for the specified data source
/////////////////////////////////////////////////////////////////////////////
CPU_API BOOL GetSourceDesc(DWORD dwIndex, LPMONITORING_SOURCE_DESC pDesc)
{
  //get host application module handle

  HMODULE hHost = GetModuleHandle(NULL);
  if (!hHost)
    return FALSE;

  //get ptr to host application ID routine and return error if the host doesn't 
  //export it

  //we'll use this condition to verify if we're under RivaTuner v2.0 RC 15.7
  //(older versions are not supported) or any other compatible host

  GET_HOST_APP_ID_PROC pGetHostAppID = (GET_HOST_APP_ID_PROC)GetProcAddress(hHost, "GetHostAppID");
  if (!pGetHostAppID)
    return FALSE;

  //get ptrs to required plugin API functions

  g_pLocalizeWnd		= (LOCALIZEWND_PROC)GetProcAddress(hHost, "LocalizeWnd");
  g_pLocalizeStr		= (LOCALIZESTR_PROC)GetProcAddress(hHost, "LocalizeStr");

  //init global variables

  if (!g_pAquastream.get())
  {
    try {
      g_pAquastream = auto_ptr<Aquastream>(new Aquastream);
    }
    catch (...) {
      return FALSE;
    }
  }

  if (dwIndex >= 7)
    //check specified data source index and return FALSE if it is invalid
    return FALSE;

  switch (dwIndex)
  {
    case 0:

      //Water Temperature
      strcpy(pDesc->szName, "Aquastream Water Temperature");
      if (pDesc->dwVersion >= 0x00010002)
        strcpy(pDesc->szGroup, "AS");
      strcpy(pDesc->szDim		, "C");


      pDesc->fltMaxLimit	= 50.0f;
      pDesc->fltMinLimit	= 20.0f;
      pDesc->fltGridDim	= 10.0f;

      strcpy(pDesc->szDesc, " Aquastream internal Water Temperature Sensor ");
      return TRUE;

    case 1:

      //External Temperature
      strcpy(pDesc->szName, "Aquastream External Temperature");
      if (pDesc->dwVersion >= 0x00010002)
        strcpy(pDesc->szGroup, "AS");
      strcpy(pDesc->szDim		, "C");


      pDesc->fltMaxLimit	= 50.0f;
      pDesc->fltMinLimit	= 20.0f;
      pDesc->fltGridDim	= 10.0f;

      strcpy(pDesc->szDesc, " Aquastream external Temperature Sensor ");
      return TRUE;

    case 2:

      //Pump Electronic Temperature
      strcpy(pDesc->szName, "Aquastream C Temperature");
      if (pDesc->dwVersion >= 0x00010002)
        strcpy(pDesc->szGroup, "AS");
      strcpy(pDesc->szDim		, "C");


      pDesc->fltMaxLimit	= 90.0f;
      pDesc->fltMinLimit	= 20.0f;
      pDesc->fltGridDim	= 10.0f;

      strcpy(pDesc->szDesc, " Aquastream internal Controller Temperature Sensor ");
      return TRUE;

    case 3:

      //Fan Voltage
      strcpy(pDesc->szName, "Aquastream Fan Output Voltage");
      if (pDesc->dwVersion >= 0x00010002)
        strcpy(pDesc->szGroup, "AS");
      strcpy(pDesc->szDim		, "V");


      pDesc->fltMaxLimit	= 12.0f;
      pDesc->fltMinLimit	= 0.0f;
      pDesc->fltGridDim	= 10.0f;

      strcpy(pDesc->szDesc, " Aquastream Fan Output Voltage ");
      return TRUE;

    case 4:

      //Fan Output
      strcpy(pDesc->szName, "Aquastream Fan Output");
      if (pDesc->dwVersion >= 0x00010002)
        strcpy(pDesc->szGroup, "AS");
      strcpy(pDesc->szDim		, "%");


      pDesc->fltMaxLimit	= 100.0f;
      pDesc->fltMinLimit	= 0.0f;
      pDesc->fltGridDim	= 10.0f;

      strcpy(pDesc->szDesc, " Aquastream relative Fan Output ");
      return TRUE;

    case 5:

      //Fan Speed
      strcpy(pDesc->szName, "Aquastream Fan Speed");
      if (pDesc->dwVersion >= 0x00010002)
        strcpy(pDesc->szGroup, "AS");
      strcpy(pDesc->szDim		, "RPM");
      if (pDesc->dwVersion >= 0x00010003)
        strcpy(pDesc->szFormat, "%.0f");


      pDesc->fltMaxLimit	= 2500.0f;
      pDesc->fltMinLimit	= 0.0f;
      pDesc->fltGridDim	= 10.0f;

      strcpy(pDesc->szDesc, " Aquastream Fan Rotation Speed ");
      return TRUE;

    case 6:

      //Alarm
      strcpy(pDesc->szName, "Aquastream Alarm");
      if (pDesc->dwVersion >= 0x00010002)
        strcpy(pDesc->szGroup, "AS");
      strcpy(pDesc->szDim		, "");
      if (pDesc->dwVersion >= 0x00010003)
        strcpy(pDesc->szFormat, "%.0f");


      pDesc->fltMaxLimit	= 1.0f;
      pDesc->fltMinLimit	= 0.0f;
      pDesc->fltGridDim	= 1.0f;

      strcpy(pDesc->szDesc, " Aquastream Alarm ");
      return TRUE;
  }

  return FALSE;
}
//////////////////////////////////////////////////////////////////////
// This exported function is called by RivaTuner to get capabilities
// for the specified data source
//////////////////////////////////////////////////////////////////////
CPU_API BOOL GetSourceCaps(DWORD dwIndex, DWORD dwCaps, LPDWORD lpResult)
{
  //all sources are system wide monitoring so it is safe to ignore passed
  //index and check just the capability

  switch (dwCaps)
  {
  case  MONITORING_SOURCE_CAPS_SYSTEM_WIDE:
    *lpResult = 1;
    return TRUE;
  }

  return FALSE;
}
/////////////////////////////////////////////////////////////////////////////
// This exported function is called by RivaTuner to check if a source
// provides any additional settings and for customizing it when <More>
// button is clicked in the source's properties window
//
// The function is called with hWnd = NULL during checking and with parent
// window's hWnd during customization
/////////////////////////////////////////////////////////////////////////////
CPU_API BOOL SetupSource(DWORD dwIndex, HWND hWnd)
{
  return FALSE; // Es gibt keinen zustzlichen Parametrierungsdialog
}
/////////////////////////////////////////////////////////////////////////////
// This exported function is called by RivaTuner to poll data sources
/////////////////////////////////////////////////////////////////////////////
CPU_API FLOAT GetSourceData(DWORD dwIndex)
{
  if (!g_pAquastream.get())
    return FLT_MAX;

  // Jeder Wert kann einmal abgefragt werden, bevor ein
  // neuer Lesevorgang von USB gestartet wird.
  static unsigned char requireRead = 0xff;
  if ((1<<dwIndex)&requireRead)
  {
    g_pAquastream->read();    // Falls Lesevorgang schief geht, liefert hasData() false und alle liefern einmal FLT_MAX
    requireRead = 1<<dwIndex;
  }
  else
    requireRead |= 1<<dwIndex;

  if (!g_pAquastream->hasData())
    return FLT_MAX;

  switch (dwIndex)
  {
    case 0:
      return g_pAquastream->GetWaterTemperature();

    case 1:
      return g_pAquastream->GetExternalTemperature();

    case 2:
      return g_pAquastream->GetPumpTemperature();

    case 3:
      return g_pAquastream->GetFanVoltage();

    case 4:
      return g_pAquastream->GetFanPercentage();

    case 5:
      return g_pAquastream->GetFanRotation();

    case 6:
      return g_pAquastream->GetAlarm();
  }
  return FLT_MAX;
}
/////////////////////////////////////////////////////////////////////////////
